import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { LogLevel } from '../../models/LogLevel';

import { LevelCell } from './LevelCell';

const Template: Story<{ value: LogLevel }> = ({ value }) => <LevelCell rowEntry={{ value }} columnName={'value'} />;

export const Default = Template.bind({});
Default.args = { value: LogLevel.ERROR };

export const AllLevels = () => (
   <>
      {Object.values(LogLevel).map(l => (
         <Default value={l} />
      ))}
   </>
);

export default {
   title: 'components/deploy-log-page/cells/LevelCell',
} as Meta;
