import { faCog, faExclamationTriangle, faInfoSquare } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { EMPTY_VALUE } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { ReactNode } from 'react';

import { CellProps } from '../../../logs-core';
import { LogLevel } from '../../models/LogLevel';

import classes from './LevelCell.module.css';

const icons = new Map<LogLevel, ReactNode>([
   [LogLevel.ERROR, <FontAwesomeIcon icon={faExclamationTriangle} fixedWidth={true} />],
   [LogLevel.WARNING, <FontAwesomeIcon icon={faExclamationTriangle} fixedWidth={true} />],
   [LogLevel.WARN, <FontAwesomeIcon icon={faExclamationTriangle} fixedWidth={true} />],
   [LogLevel.INFO, <FontAwesomeIcon icon={faInfoSquare} fixedWidth={true} />],
   [LogLevel.DEBUG, <FontAwesomeIcon icon={faCog} fixedWidth={true} />],
   [LogLevel.JSON, null],
]);

export const LevelCell: React.FC<CellProps> = React.memo(({ rowEntry, columnName }) => {
   const value = rowEntry[columnName];

   return (
      <div className={classes[value]}>
         {icons.get(value)} {value || EMPTY_VALUE}
      </div>
   );
});

LevelCell.displayName = 'LevelCell';
