import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { LogSourceCell } from './LogSourceCell';

const Template: Story<{}> = () => (
   <LogSourceCell
      rowEntry={{
         box: 'box',
         workload: 'WorkloadJsonLogs',
         containerId: 'pod_agent_box_box/workload_WorkloadJsonLogs_start',
         seq: '18446744073709514754',
         podPersistentFqdn: 'w3yabiy2ygkfafcp.sas.yp-c.yandex.net',
         threadName: '',
         userId: '',
         nodeFqdn: 'sas3-5602.search.yandex.net',
         host: 'sas3-5602-2.w3yabiy2ygkfafcp.sas.yp-c.yandex.net',
         requestId: '',
         podTransientFqdn: 'sas3-5602-2.w3yabiy2ygkfafcp.sas.yp-c.yandex.net',
         pod: 'w3yabiy2ygkfafcp',
      }}
      columnName={'source'}
   />
);

export const Default = Template.bind({});

Default.storyName = 'LogSourceCell'; // Remove if it isn't single story
Default.args = {};

export default {
   title: 'components/deploy-log-page/cells/LogSourceCell',
} as Meta;
