import { Popover } from '@yandex-cloud/uikit';
import * as React from 'react';

import { CellProps, useLogPageContext } from '../../../logs-core';

import classes from './LogSourceCell.module.css';

export const LogSourceCell: React.FC<CellProps> = React.memo(({ rowEntry }) => {
   const { queryProvider } = useLogPageContext()!;
   const { deployUnitId } = queryProvider.getForcedRequestParams();
   const { box, workload } = rowEntry;

   return (
      <div className={classes.wrapper}>
         <Popover
            placement={['bottom', 'top', 'left', 'right']}
            content={
               <div className={classes.tooltipContent}>
                  <span>
                     <b>Deploy Unit</b> {deployUnitId} /
                  </span>{' '}
                  <span>
                     <b>Box</b> {box} /
                  </span>{' '}
                  <span>
                     <b>Workload</b> {workload}
                  </span>
               </div>
            }
            openOnHover={true}
         >
            <div>... / {workload}</div>
         </Popover>
      </div>
   );
});

LogSourceCell.displayName = 'LogSourceCell';
