import { EMPTY_VALUE } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { CellProps } from '../../../logs-core';

import classes from './MessageCell.module.css';

export const MessageCell: React.FC<CellProps> = React.memo(({ rowEntry, columnName }) => {
   const value = rowEntry[columnName];

   return <div className={classes.wrapper}>{value || EMPTY_VALUE}</div>;
});

MessageCell.displayName = 'MessageCell';
