import { StageLogsParams } from '../../models/ui';
import { FieldType, Operator, QueryField } from '../logs-core';
import { ColumnNames } from './models/ColumnNames';

export const requiredFilters: (keyof StageLogsParams)[] = ['deployUnitId'];

export const customRequestFields: QueryField[] = [
   {
      keyType: 'MESSAGE',
      name: ColumnNames.Message,
      type: FieldType.String,
      operators: [],
   },
   {
      keyType: 'STACK_TRACE',
      name: ColumnNames.StackTrace,
      type: FieldType.String,
      operators: [],
   },
   {
      keyType: 'CONTEXT',
      name: ColumnNames.Context,
      type: FieldType.String,
      operators: [],
   },
];

export const clickableRequestFields: QueryField[] = [
   {
      keyType: 'LOG_LEVEL',
      name: ColumnNames.LogLevel,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'HOST',
      name: ColumnNames.Host,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'POD',
      name: ColumnNames.Pod,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'BOX',
      name: ColumnNames.Box,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'WORKLOAD',
      name: ColumnNames.Workload,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'CONTAINER_ID',
      name: ColumnNames.ContainerId,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'LOGGER_NAME',
      name: ColumnNames.LoggerName,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'POD_TRANSIENT_FQDN',
      name: ColumnNames.PodTransientFqdn,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'POD_PERSISTENT_FQDN',
      name: ColumnNames.PodPersistentFqdn,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'NODE_FQDN',
      name: ColumnNames.NodeFqdn,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'THREAD_NAME',
      name: ColumnNames.ThreadName,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
   {
      keyType: 'REQUEST_ID',
      name: ColumnNames.RequestId,
      operators: [Operator.Equal, Operator.NotEqual],
      type: FieldType.String,
   },
];
