import { YCSelect } from '@yandex-data-ui/common';
import { isEmpty } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useCallback, useEffect, useMemo, useState } from 'react';

import { FilterProps, PlainObject } from '../../../logs-core';

import classes from './DeployUnitFilter.module.css';

const DeployUnitFilterImpl: React.FC<FilterProps<string | undefined, { deployUnitIds: string[] }>> = React.memo(
   ({ internalProps, value, onUpdate }) => {
      const deployUnitIds = useMemo(() => internalProps?.deployUnitIds ?? [], [internalProps?.deployUnitIds]);
      const emptyValue = useMemo(() => isEmpty(value) && !isEmpty(deployUnitIds), [deployUnitIds, value]);

      // для сохранения значения, выбранного пользователем в селекте при сбросе фильтров
      const [selectedDeployUnitId, setSelectedDeployUnitId] = useState(value ?? deployUnitIds[0]);

      useEffect(() => {
         if (emptyValue) {
            if (selectedDeployUnitId) {
               onUpdate(selectedDeployUnitId, true);
            }
         }
      }, [onUpdate, emptyValue, selectedDeployUnitId]);

      const items = useMemo(
         () =>
            deployUnitIds?.map(id => ({
               title: id,
               value: id,
            })) ?? [],
         [deployUnitIds],
      );

      const handleUpdate = useCallback(
         (v: string) => {
            setSelectedDeployUnitId(v);
            onUpdate(v, true);
         },
         [onUpdate],
      );

      return (
         <div className={classes.wrapper}>
            <YCSelect
               value={value}
               items={items}
               onUpdate={handleUpdate}
               controlWidth={260}
               showSearch={false}
               disabled={items.length < 2}
            />
         </div>
      );
   },
);

export const DeployUnitFilter = Object.assign(DeployUnitFilterImpl, {
   getValueFromUrlParams(urlParams: PlainObject): string | undefined {
      return urlParams.deployUnitId;
   },
   setUrlParamsFromValue(v: string | undefined): PlainObject {
      const result: PlainObject = {};

      if (v) {
         result.deployUnitId = v;
      }

      return result;
   },
});

DeployUnitFilter.displayName = 'DeployUnitFilter';
