import { InputField2, TextField2 } from '@yandex-infracloud-ui/libs';
import { Form } from 'formik';
import React from 'react';
import { object, string } from 'yup';

import modalClasses from '../../../design/commonModals.module.css';
import { TicketAction } from '../../../models/ui';
import classes from './DeployTicketActionForm.module.css';

export const DEFAULT_REASON = 'ManualCommit';

export const deployTicketFormInitialValue = {
   message: '',
   reason: DEFAULT_REASON,
};

export type TicketActionParams = typeof deployTicketFormInitialValue;

export const ticketActionParamsValidationSchema = object<TicketActionParams>({
   reason: string(),
   message: string(),
});

interface Props {
   action: TicketAction;
}

const actionsWithReason = new Set([TicketAction.Commit, TicketAction.Skip]);

export const DeployTicketActionForm: React.FC<Props> = React.memo(({ children, action }) => (
   <Form className={modalClasses.form}>
      <TextField2 name={'message'} label={'Message'} placeholder={'Describe your action'} />

      {actionsWithReason.has(action) && (
         <div hidden={true}>
            <InputField2 name={'reason'} label={'Reason'} placeholder={'Machine readable string'} readonly={true} />
         </div>
      )}

      <p className={classes.info}>
         When performing manual actions on tickets, the field 'reason' with the value 'ManualCommit' will be
         automatically set
      </p>

      {children}
   </Form>
));

DeployTicketActionForm.displayName = 'DeployTicketActionForm';
