import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import { modalService, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';
import { TicketAction } from '../../../models/ui';

import { apiServicesContextDecorator, modalsSupportDecorator } from '../../../stories';

import { DeployTicketActionModal } from './DeployTicketActionModal';

export const Form = () => (
   <DeployTicketActionModal
      action={TicketAction.Skip}
      initialMessage={'release title by default'}
      labels={{
         title: 'Skip ticket',
         actionInProcess: 'Ticket is skipping',
         submitButton: 'Skip',
      }}
      patchIds={['patch1']}
      ticketId={'ticket1'}
      ok={action('ok')}
      cancel={action('cancel')}
   />
);

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(
            DeployTicketActionModal,
            {
               action: TicketAction.Commit,
               initialMessage: 'release title',
               labels: {
                  title: 'Commit ticket',
                  actionInProcess: 'Ticket is committing',
                  submitButton: 'Commit',
               },
               patchIds: [] as string[],
               ticketId: 'ticket.id',
            },
            { closeOnOutsideClick: false },
         )
         .pipe(takeUntil(dismounted))
         .subscribe(action('success'), action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};

export default {
   decorators: [modalsSupportDecorator, apiServicesContextDecorator],
   title: 'pages/stages/_stageId/deploy-tickets/TicketActionModal',
} as Meta;
