import { Meta } from '@storybook/react';
import React, { useEffect, useState } from 'react';
import { useDispatch } from 'react-redux';

import { initialDeployTicketFilters, ReleaseRule, ReleaseRuleType } from '../../../models/ui';
import { releaseRulesSlice } from '../../../redux';
import { reduxDecorator } from '../../../stories';

import { DeployTicketFiltersView } from './DeployTicketFiltersView';

const rules: ReleaseRule[] = [
   {
      autocommit: false,
      creationDate: Date.now(),
      description: '',
      id: 'releaseRule1',
      patchCount: 1,
      stageId: 'stage1',
      type: ReleaseRuleType.Sandbox,
   },
   {
      autocommit: false,
      creationDate: Date.now(),
      description: '',
      id: 'releaseRule2',
      patchCount: 1,
      stageId: 'stage1',
      type: ReleaseRuleType.Docker,
   },
];

export const Regular = () => {
   const dispatch = useDispatch();

   useEffect(() => {
      dispatch(releaseRulesSlice.actions.setRulesForTests(rules));
   }, [dispatch]);

   const [filters, setFilters] = useState(initialDeployTicketFilters);

   return <DeployTicketFiltersView filters={filters} setFilters={setFilters} />;
};

export default {
   decorators: [reduxDecorator],
   title: 'pages/stages/_stageId/deploy-tickets/DeployTicketFiltersView',
} as Meta;
