import { YCSelect, YCSelectItem, YCSelectItemsGroup } from '@yandex-data-ui/common';
import React, { useCallback, useMemo } from 'react';
import {
   TicketStatus,
   ActiveTicketStatuses,
   TICKET_STATUS_NAMES,
   HistoryTicketStatuses,
} from '../../../../../models/ui';
import { DeployTicketStatus } from '../../../DeployTicketStatus/DeployTicketStatus';

interface Props<T = Set<TicketStatus>> {
   value: T;
   onChange: (value: T) => void;
   width?: number;
}

const getItem: (status: TicketStatus) => YCSelectItem = status => ({
   title: TICKET_STATUS_NAMES[status],
   value: status,
   icon: (
      <DeployTicketStatus status={status} isAnimated={false}>
         <span hidden={true}>{status}</span>
      </DeployTicketStatus>
   ),
});

const ticketStatusOptionGroups: YCSelectItemsGroup[] = [
   {
      groupTitle: 'Active',
      items: ActiveTicketStatuses.map(getItem),
   },
   {
      groupTitle: 'History',
      items: HistoryTicketStatuses.map(getItem),
   },
];

export const DeployTicketStatusSelect: React.FC<Props> = React.memo(({ onChange, value, width }) => {
   const onTicketChange = useCallback(
      (selectedStatuses: TicketStatus[]) => {
         const statuses = selectedStatuses.length > 0 ? selectedStatuses : ActiveTicketStatuses;
         onChange(new Set(statuses));
      },
      [onChange],
   );

   const items = useMemo(() => [...value.values()], [value]);

   return (
      <YCSelect
         showItemIcon={true}
         type={'multiple'}
         onUpdate={onTicketChange as (value: string[]) => void} // пока YCSelect не научится определять типы
         items={ticketStatusOptionGroups}
         value={items as string[]} // TODO fix typings
         controlWidth={width ?? 220}
      />
   );
});

DeployTicketStatusSelect.displayName = 'DeployTicketStatusSelect';
