import React from 'react';

import { LegoTextInput } from '../../../../../_lego';

import classes from './IdTextInput.module.css';

function renderInputTitle(title: string, value: string): string {
   return value ? `${title}: ${value}` : title;
}

interface Props {
   value?: string;
   title: string;

   onChange(v: string): void;
}

export const IdTextInput: React.FC<Props> = React.memo(({ value, onChange, title }) => (
   <LegoTextInput
      theme={'normal'}
      size={'s'}
      cls={classes.field}
      placeholder={title}
      text={value}
      onChange={e => {
         onChange(e);
      }}
      controlAttrs={{
         title: renderInputTitle(title, value ?? ''),
      }}
      hasClear={true}
   />
));

IdTextInput.displayName = 'IdTextInput';
