import { HelpPopover } from '@yandex-cloud/uikit';
import { classNames } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';

import { LegoCheckBox } from '../../../_lego';
import { ReleasePromoCard } from '../../release';
import { Column, columnsList, ItemMode } from '../model';

import classes from './DeployTicketHead.module.css';

interface Props {
   isAllSelected?: boolean | null;
   mode: ItemMode;
   excludeColumns?: Set<Column>;

   toggleAll?(): void;
}

const titles: Record<Column, ReactNode> = {
   id: 'Ticket ID',
   stage: 'Stage',
   release: (
      <span>
         Release <HelpPopover content={<ReleasePromoCard />} />
      </span>
   ),
   releaseRule: 'Release Rule',
   status: 'Status',
   approves: 'Approves',
   date: 'Date',
};

export const DeployTicketHead: React.FC<Props> = React.memo(
   ({ mode, toggleAll, isAllSelected = false, excludeColumns }) => {
      const columns: readonly Column[] = excludeColumns ? columnsList.filter(e => !excludeColumns.has(e)) : columnsList;

      const inList = mode === 'list';
      return (
         <div className={classNames(classes.head, inList ? classes.headList : classes.headSingle)}>
            {inList && (
               <div className={classes.colCheckbox}>
                  <LegoCheckBox
                     theme={'normal'}
                     size={'s'}
                     view={'default'}
                     tone={'grey'}
                     checked={isAllSelected !== false}
                     indeterminate={isAllSelected === null}
                     onChange={toggleAll}
                  />
               </div>
            )}
            <div className={classes.titles} style={{ gridTemplateColumns: `repeat(${columns.length}, 1fr)` }}>
               {columns.map(name => (
                  <div key={name}>{titles[name]}</div>
               ))}
            </div>
            <div className={classes.colButtons} aria-label={'Actions'} />
         </div>
      );
   },
);

DeployTicketHead.displayName = 'DeployTicketHead';
