import React, { useState } from 'react';
import { DeployTicketHead } from '../DeployTicketHead/DeployTicketHead';
import { DeployTicketRow } from '../DeployTicketRow/DeployTicketRow';
import { DeployTicketSizeContainer } from '../DeployTicketSizeContainer/DeployTicketSizeContainer';

interface Props {
   ticketId: string;
}

export const DeployTicketItem: React.FC<Props> = React.memo(({ ticketId }) => {
   const [selectedPatches, setSelectedPatches] = useState(new Set<string>());
   return (
      <DeployTicketSizeContainer>
         <DeployTicketHead mode={'single'} />
         <DeployTicketRow
            ticketId={ticketId}
            mode={'single'}
            selectedPatches={selectedPatches}
            onSelectPatches={setSelectedPatches}
         />
      </DeployTicketSizeContainer>
   );
});

DeployTicketItem.displayName = 'DeployTicketItem';
