import { WarningPlate } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { DeployTicketGroups } from '../../../model';

interface Props {
   deployTicketGroups: DeployTicketGroups;
}

export const DeployTicketSafeModePlate: React.FC<Props> = ({ deployTicketGroups }) => {
   const { unknownTicketIds, stagesWithMultiTickets } = deployTicketGroups;
   return (
      <WarningPlate>
         {unknownTicketIds.size > 0 && (
            <p>
               There are <em title={Array.from(unknownTicketIds).join(',')}>some tickets ({unknownTicketIds.size})</em>{' '}
               without information about stages.
            </p>
         )}
         {stagesWithMultiTickets.size > 0 && (
            <p>
               There are{' '}
               <em title={Array.from(stagesWithMultiTickets).join(',')}>some stages ({stagesWithMultiTickets.size})</em>{' '}
               for which deploy tickets have merge conflicts when applied to the same deploy unit or have no binding to
               deploy unit, which can also lead to merge conflicts.
            </p>
         )}
         <p>A safe limit of 1 request will be set to avoid merge conflicts.</p>
      </WarningPlate>
   );
};
