import { Meta } from '@storybook/react';
import { addMinutes } from 'date-fns';
import React from 'react';

import { ExecutionDate } from './ExecutionDate';

export const Empty = () => <ExecutionDate start={null} end={null} />;

export const WithoutStart = () => <ExecutionDate start={null} end={new Date()} />;

export const WithoutEnd = () => <ExecutionDate start={new Date()} end={null} />;

export const Both = () => <ExecutionDate start={new Date()} end={addMinutes(new Date(), 4)} />;

export default {
   title: 'pages/stages/_stageId/deploy-tickets/DeployTicketItem/ExecutionDate',
} as Meta;
