import { classNames, EMPTY_VALUE, formatDate, timeDistance } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './ExecutionDate.module.css';

interface Props {
   className?: string;
   end: Date | null;
   start: Date | null;
   create?: Date | null;
}

export const ExecutionDate: React.FC<Props> = React.memo(({ className, end, start, create }) => (
   <div className={classNames(classes.date, className)}>
      {create && (
         <time className={classes.start} dateTime={start ? start.toJSON() : undefined}>
            Create: {create ? formatDate(create) : EMPTY_VALUE}
         </time>
      )}
      {(start || end) && (
         <div title={end && start ? `Duration: ${timeDistance(end, start)}` : undefined}>
            <time className={classes.start} dateTime={start ? start.toJSON() : undefined}>
               Start: {start ? formatDate(start) : EMPTY_VALUE}
            </time>
            <time className={classes.end} dateTime={end ? end.toJSON() : undefined}>
               End: {end ? formatDate(end) : EMPTY_VALUE}
            </time>
         </div>
      )}
      {!(create || start || end) && EMPTY_VALUE}
   </div>
));

ExecutionDate.displayName = 'ExecutionDate';
