import { EMPTY_VALUE, styleHelpers } from '@yandex-infracloud-ui/libs';
import { CheckBox } from 'lego-on-react';
import React from 'react';
import { Link } from 'react-router-dom';
import { urlBuilder } from '../../../../../models';

import { DeployPatch, MutableTicketStatuses, TicketStatus } from '../../../../../models/ui/releases';
import { DeployTicketStatus } from '../../../DeployTicketStatus/DeployTicketStatus';

import classes from './PatchCells.module.css';

interface Props {
   patch: DeployPatch;

   selected?: boolean;
   stageId: string;
   waitingForApprove: boolean;

   toggle?(e: React.KeyboardEvent<HTMLInputElement>): void;
}

export const PatchCells = React.memo(({ selected, toggle, patch, stageId, waitingForApprove }: Props) => (
   <>
      <td className={classes.patchCell}>
         {selected !== undefined ? (
            <CheckBox
               theme={'normal'}
               size={'s'}
               view={'default'}
               tone={'grey'}
               checked={selected}
               onChange={toggle}
               disabled={!MutableTicketStatuses.has(patch.status)}
               cls={styleHelpers.rightSpace}
            >
               {patch.id}
            </CheckBox>
         ) : (
            patch.id
         )}
      </td>
      <td className={classes.patchCell}>
         {patch.deployUnitId ? (
            <Link to={urlBuilder.stageConfig(stageId, patch.deployUnitId)}>{patch.deployUnitId}</Link>
         ) : (
            EMPTY_VALUE
         )}
      </td>
      <td className={classes.patchCell}>
         <DeployTicketStatus status={waitingForApprove ? TicketStatus.WaitingForApprove : patch.status} />
      </td>
   </>
));

PatchCells.displayName = 'PatchCells';
