import React from 'react';

import { TicketStatus, TICKET_STATUS_NAMES } from '../../../models/ui';
import { Status, StatusState } from '../../lib';

interface Props {
   status: TicketStatus;
   isAnimated?: boolean;
}

const statusMap: Partial<Record<TicketStatus, StatusState>> = {
   [TicketStatus.Success]: StatusState.Ok,
   [TicketStatus.Closed]: StatusState.Ok,
   [TicketStatus.Cancelled]: StatusState.Inactive,
   [TicketStatus.Skip]: StatusState.Inactive,
   [TicketStatus.Failed]: StatusState.Error,
   [TicketStatus.InProgress]: StatusState.Progress,
   [TicketStatus.Pending]: StatusState.Progress,
   [TicketStatus.Committed]: StatusState.Planned,
   [TicketStatus.Wait]: StatusState.Planned,
   [TicketStatus.OnHold]: StatusState.Planned,
   [TicketStatus.WaitingForApprove]: StatusState.Pause,
   [TicketStatus.WaitingForCommit]: StatusState.Pause,
   [TicketStatus.Unknown]: StatusState.Unknown,
};

export const DeployTicketStatus: React.FC<Props> = React.memo(({ status, isAnimated = true, children }) => (
   <Status state={statusMap[status] ?? StatusState.Unknown} isAnimated={isAnimated}>
      {children ?? TICKET_STATUS_NAMES[status] ?? status}
   </Status>
));

DeployTicketStatus.displayName = 'DeployTicketStatus';
