import { useCallback, useMemo } from 'react';
import { useSelector } from 'react-redux';
import { RootState, selectDeployTicketsByIds } from '../../../redux';
import { DeployTicketGroups, getDeployTicketGroups } from '../model';

/**
 * разбиение тикетов на группы по стейджам и отслеживание конфликтов в патчах
 */
export function useDeployTicketGroups(deployTicketIds: Set<string>): DeployTicketGroups {
   const ticketsSelector = useCallback((state: RootState) => selectDeployTicketsByIds(state, deployTicketIds), [
      deployTicketIds,
   ]);

   const ticketsMap = useSelector(ticketsSelector);

   return useMemo(() => getDeployTicketGroups(ticketsMap), [ticketsMap]);
}
