import { useCallback } from 'react';

import { formatDate } from '@yandex-infracloud-ui/libs';

import { DeployTicketPageType } from '../model';
import { useRelease } from '../../../redux/hooks/useRelease';
import { useDeployTicket } from '../../../redux/hooks/useDeployTicket';
import { TicketAction } from '../../../models/ui';

export interface MassActionMessageOptions {
   pageType: DeployTicketPageType;
   selectedTickets: Map<string, Set<string>>;
}

/**
 * Вставка в сообщение массовой операции информации из релиза, если он есть;
 * либо информации о стейдже, если массовая операция выполняется со страницы стейджа
 */
export function useMassActionMessage({
   pageType,
   selectedTickets,
}: MassActionMessageOptions): (action: TicketAction) => string {
   const firstTicketId = Array.from(selectedTickets.keys())[0] ?? '';
   const { deployTicket } = useDeployTicket(firstTicketId);

   const releaseId = pageType === DeployTicketPageType.release ? deployTicket?.releaseId ?? null : null;
   const stageId = deployTicket?.stageId ?? null;

   const { release } = useRelease(releaseId);

   const releaseMessage = release?.description || release?.title || null;
   const stageMessage = pageType === DeployTicketPageType.stage && stageId ? ` for stage ${stageId}` : '';

   return useCallback(
      (action: TicketAction) =>
         `${releaseMessage ? `${releaseMessage}\n` : ''}${getDefaultMessage(action)}${stageMessage}`,
      [releaseMessage, stageMessage],
   );
}

function getDefaultMessage(action: TicketAction): string {
   return `Mass action: ${action} at ${formatDate(Date.now())}`;
}
