import {
   ExtendedFieldConfig,
   FieldLayout2,
   RoundedInputControlProps,
   useExtendedField,
} from '@yandex-infracloud-ui/libs';
import React from 'react';

import { BandwidthInput } from '../../inputs';

export const BandwidthField = React.memo((props: ExtendedFieldConfig<any, number | null, RoundedInputControlProps>) => {
   const { field, onChange, readonly, disabled, onBlur, showError } = useExtendedField(props);

   return (
      <FieldLayout2 {...props}>
         <BandwidthInput
            disabled={disabled}
            hasError={Boolean(showError)}
            name={field.name}
            onBlur={onBlur}
            onChange={onChange}
            placeholder={props.placeholder}
            readonly={readonly}
            useRenderDetails={props.controlProps?.useRenderDetails}
            value={field.value ?? null}
         />
      </FieldLayout2>
   );
});

BandwidthField.displayName = 'BandwidthField';
