import {
   classNames,
   DropdownCheckboxList,
   EMPTY_VALUE,
   ExtendedFieldConfig,
   FieldLayout2,
   IEnumOption,
   IListOption,
   useExtendedField,
} from '@yandex-infracloud-ui/libs';
import React, { SyntheticEvent, useCallback, useMemo } from 'react';
import commonClasses from '../../../../design/lego-form-fields-error.module.css';

import classes from './CheckboxListField.module.css';

interface CheckboxListFieldControlProps {
   options: IEnumOption[];
}

export const CheckboxListField = React.memo(
   (props: ExtendedFieldConfig<any, string[], CheckboxListFieldControlProps>) => {
      const { disabled, field, onChange, readonly, showError } = useExtendedField(props);

      const options: IListOption[] = useMemo(
         () =>
            (props.controlProps?.options ?? []).map(
               o =>
                  ({
                     value: o.value,
                     name: o.title,
                  } as IListOption),
            ),
         [props.controlProps],
      );

      const getReadonlyValue = useCallback(() => {
         const valueItems = (field.value as string[])
            .map(v => {
               const option = options.find(o => o.value === v);

               return option ? option.name : v;
            })
            .join(', ');

         return valueItems || props.placeholder || EMPTY_VALUE;
      }, [field.value, options, props.placeholder]);

      const onChangeFixed = useCallback(
         (e: SyntheticEvent, v: Set<string>) => {
            onChange(Array.from(v));
         },
         [onChange],
      );

      return (
         <FieldLayout2 {...props}>
            {readonly ? (
               <div className={classes.readonlyValue}>{getReadonlyValue()}</div>
            ) : (
               <DropdownCheckboxList
                  name={field.name}
                  value={new Set(field.value)}
                  disabled={disabled}
                  className={classNames(classes.control, { [commonClasses.error]: showError })}
                  options={options}
                  onChange={onChangeFixed}
                  getLabel={getReadonlyValue}
               />
            )}
         </FieldLayout2>
      );
   },
);

CheckboxListField.displayName = 'CheckboxListField';
