import {
   ExtendedFieldConfig,
   FieldLayout2,
   RoundedInputControlProps,
   useExtendedField,
} from '@yandex-infracloud-ui/libs';
import React from 'react';
import { VCpuInput } from '../../inputs';

export const CpuLimitField = React.memo((props: ExtendedFieldConfig<any, number | null, RoundedInputControlProps>) => {
   const { field, onChange, readonly, disabled, onBlur, showError } = useExtendedField(props);

   return (
      <FieldLayout2 {...props}>
         <VCpuInput
            disabled={disabled}
            hasError={Boolean(showError)}
            name={field.name}
            onBlur={onBlur}
            onChange={onChange}
            placeholder={props.placeholder}
            readonly={readonly}
            value={field.value ?? null}
            useRenderDetails={props.controlProps?.useRenderDetails}
         />
      </FieldLayout2>
   );
});

CpuLimitField.displayName = 'CpuLimitField';
