import { classNames, ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { EnabledSwitcher } from '../../inputs';

import classes from './EnabledSwitcherField.module.css';

export const EnabledSwitcherField = React.memo((props: ExtendedFieldConfig<any, boolean>) => {
   const { field, disabled, onBlur, onChange, readonly, showError } = useExtendedField(props);

   return (
      <FieldLayout2 {...props}>
         {readonly ? (
            <div className={classNames({ [classes.readonly]: readonly })}>{field.value ? 'Enabled' : 'Disabled'}</div>
         ) : (
            <EnabledSwitcher
               name={field.name}
               value={field.value}
               onChange={onChange}
               disabled={disabled}
               hasError={showError}
               id={field.name}
               onBlur={onBlur}
               placeholder={props.placeholder}
               readonly={readonly}
               {...props.controlProps}
            />
         )}
      </FieldLayout2>
   );
});

EnabledSwitcherField.displayName = 'EnabledSwitcherField';
