import { faPlus } from '@fortawesome/pro-regular-svg-icons';
import { EMPTY_VALUE, FieldLayout2, FormButton } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React, { useCallback } from 'react';
import { Props } from './models';

import { MultipleInputRow } from './MultipleInputRow';

export const MultipleInputField: React.FC<Props> = React.memo(({ controlProps, ...props }: Props) => {
   const { name, label, readonly, disabled } = props;
   const form = useFormikContext();

   const { value } = form.getFieldMeta<(string | null)[]>(`${name}`);

   const handleAddItem = useCallback(() => {
      const newItems = [...(value ?? []), null];

      form.setFieldValue(`${name}`, newItems);
   }, [form, name, value]);

   const handleRemoveItem = useCallback(
      (i: number) => {
         const newItems = [...(value ?? [])];
         newItems.splice(i, 1);

         form.setFieldTouched(`${name}[${i}]`, false);
         form.setFieldValue(`${name}`, newItems);
      },
      [form, name, value],
   );

   return (
      <div data-test={'MultipleInputField'}>
         <FieldLayout2
            name={name}
            label={label}
            hideErrors={true}
            hint={controlProps.hint}
            readonly={readonly}
            disabled={disabled}
            readonlyDots={!(value?.length && value.length > 0)}
         >
            {value?.length && value.length > 0
               ? value.map((_: any, i: any) => (
                    <MultipleInputRow
                       // eslint-disable-next-line react/no-array-index-key
                       key={i}
                       index={i}
                       name={`${name}[${i}]`}
                       onRemove={handleRemoveItem}
                       disabled={disabled}
                       readonly={readonly}
                       placeholder={controlProps.placeholder ?? ''}
                    />
                 ))
               : readonly || disabled
               ? EMPTY_VALUE
               : null}

            {!(disabled || readonly) ? (
               <FormButton
                  icon={faPlus}
                  onClick={handleAddItem}
                  skipLeftSpace={true}
                  dataE2e={'MultipleInputField:AddButton'}
               >
                  {controlProps.addText ?? 'Add'}
               </FormButton>
            ) : null}
         </FieldLayout2>
      </div>
   );
});

MultipleInputField.displayName = 'MultipleInputField';
