import { faTimes } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { InputField2 } from '@yandex-infracloud-ui/libs';
import { getIn, useFormikContext } from 'formik';
import React, { useCallback } from 'react';

import { LegoButton } from '../../../../_lego';

import classes from './MultipleInputRow.module.css';

interface Props {
   disabled: boolean;
   index: number;
   name: string;
   placeholder: string;
   readonly: boolean;

   onRemove(i: number): void;
}

export const MultipleInputRow: React.FC<Props> = React.memo(
   ({ index, name, readonly, disabled, onRemove, placeholder }) => {
      const form = useFormikContext();
      const value: string = getIn(form.values, name);

      const handleRemove = useCallback(() => {
         onRemove(index);
      }, [index, onRemove]);

      return (
         <div className={classes.wrapper} data-test={`MultipleInputRow:${index + 1}`}>
            <div className={classes.url} data-test={'MultipleInputRow:Input'}>
               {readonly ? (
                  value
               ) : (
                  <InputField2
                     name={name}
                     label={null}
                     placeholder={placeholder}
                     readonly={readonly}
                     disabled={disabled}
                  />
               )}
            </div>

            {/* TODO: <RemoveButton /> */}
            {!disabled && !readonly ? (
               <LegoButton
                  theme={'clear'}
                  onClick={handleRemove}
                  controlAttrs={{ 'data-e2e': `MultipleInputRow${index + 1}:Clear` }}
               >
                  <FontAwesomeIcon icon={faTimes} />
               </LegoButton>
            ) : null}
         </div>
      );
   },
);

MultipleInputRow.displayName = 'MultipleInputRow';
