import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Form, Formik } from 'formik';
import React from 'react';

import { DevForm } from '../../../lib';

import { TagsField } from './TagsField';

const formValue = {
   tags: ['123', 'tag12'],
};

export const Regular = () => (
   <Formik initialValues={formValue} onSubmit={action('onSubmit')}>
      {() => (
         <Form>
            <TagsField
               name={'tags'}
               label={'Tags'}
               disabled={boolean('disabled', false)}
               readonly={boolean('readonly', false)}
               required={boolean('required', false)}
            />
            <DevForm open={true} />
         </Form>
      )}
   </Formik>
);

Regular.storyName = 'TagsField';

export default {
   title: 'components/forms/fields/TagsField',
} as Meta;
