import { EMPTY_VALUE, ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs';
import React, { SyntheticEvent, useCallback, useMemo } from 'react';

import { TagInputEnhanced } from '../../inputs/TagInput/TagInput';
import { setToListOptions, TagList } from '../../inputs/TagList/TagList';

import classes from './TagsField.module.css';

export const TagsField = React.memo((props: ExtendedFieldConfig<any, string[]>) => {
   const { field, onBlur, onChange, readonly, disabled } = useExtendedField(props);

   const value = useMemo(() => new Set(field.value), [field.value]);

   const handleOnChange = useCallback(
      (e: SyntheticEvent, v: Set<string>) => {
         onChange(Array.from(v));
      },
      [onChange],
   );

   return (
      <FieldLayout2 {...props}>
         {readonly ? (
            value.size > 0 ? (
               <TagList editable={false} items={setToListOptions(value)} />
            ) : (
               EMPTY_VALUE
            )
         ) : (
            <>
               <TagInputEnhanced
                  className={classes.control}
                  disabled={disabled}
                  onBlur={onBlur}
                  onChange={handleOnChange}
                  value={value}
               />
            </>
         )}
      </FieldLayout2>
   );
});

TagsField.displayName = 'TagsField';
