import { Meta } from '@storybook/react';
import { DevJson } from '@yandex-infracloud-ui/libs';
import React, { useState } from 'react';

import { BandwidthInput } from './BandwidthInput';

const Story = ({ v }: { v: number | null }) => {
   const [value, setValue] = useState<number | null>(v);

   return (
      <>
         <BandwidthInput name={'test'} value={value} onChange={setValue} />
         <DevJson open={true}>{value}</DevJson>
      </>
   );
};

export const Empty = () => <Story v={null} />;

export const Use_500KB_per_s = () => <Story v={1024 * 500} />;

export const Use_1MB_per_s = () => <Story v={1024 ** 2} />;

export const Use_12MB_per_s = () => <Story v={1024 ** 2 * 12} />;

export const HugeButNotRounding = () => <Story v={1024 ** 2 * 12.56} />;

export default {
   title: 'components/forms/inputs/BandwidthInput',
} as Meta;
