import { BaseInputProps, formatNumber, RoundedInput, RoundMeasure } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './BandwidthInput.module.css';

const measures: RoundMeasure[] = [
   { name: 'B/s', multiplier: 1 },
   { name: 'MB/s', multiplier: 1024 ** 2 },
];

export const renderDetails = (v: number) =>
   v >= 1024 ? `${formatNumber(v)} B/s (~${formatNumber(v, '0.0 ib').replace('i', '')}/s)` : `${formatNumber(v)} B/s`;

interface Props extends BaseInputProps<number | null> {
   useRenderDetails?: boolean;
}

export const BandwidthInput: React.FC<Props> = React.memo(({ useRenderDetails = true, ...props }) => (
   <RoundedInput
      defaultMeasure={'MB/s'}
      measures={measures}
      useRenderDetails={useRenderDetails}
      renderDetails={renderDetails}
      fixedWidth={75}
      readonlyClassName={classes.readonly}
      {...props}
   />
));

BandwidthInput.displayName = 'BandwidthInput';
