import { action } from '@storybook/addon-actions';
import { boolean, text } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { DevJson } from '@yandex-infracloud-ui/libs';
import React, { useState } from 'react';

import { EnabledSwitcher } from './EnabledSwitcher';

export const Custom = () => {
   const [value, setValue] = useState(false);

   return (
      <>
         <EnabledSwitcher
            name={'test'}
            value={value}
            onChange={setValue}
            disabled={boolean('disabled', false)}
            hasError={boolean('hasError', false)}
            readonly={boolean('readonly', false)}
            onBlur={action('onBlur')}
            placeholder={text('placeholder', '')}
         />

         <DevJson summary={'value'} open={true}>
            {value}
         </DevJson>
      </>
   );
};

export default {
   title: 'components/forms/inputs/EnabledSwitcher',
} as Meta;
