import { ControlGroupOption } from '@yandex-cloud/uikit';
import { BaseInputProps, EnumSwitcher } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

import classes from './EnabledSwitcher.module.css';

enum Options {
   Enabled = 'enabled',
   Disabled = 'disabled',
}

const options: ControlGroupOption[] = [
   { value: Options.Enabled, content: 'Enabled' },
   { value: Options.Disabled, content: 'Disabled' },
];

export const EnabledSwitcher: React.FC<BaseInputProps<boolean>> = React.memo(
   ({ value, onChange, onBlur, name, ...rest }) => {
      const handleEnabledChange = useCallback(
         (v: Options) => {
            onChange(v === Options.Enabled);

            if (onBlur) {
               onBlur();
            }
         },
         [onBlur, onChange],
      );

      return (
         <EnumSwitcher
            name={name ?? 'enabled'}
            value={value ? Options.Enabled : Options.Disabled}
            onChange={handleEnabledChange}
            options={options}
            readonlyClassName={classes.readonly}
            {...rest}
         />
      );
   },
);

EnabledSwitcher.displayName = 'EnabledSwitcher';
