import { BaseInputProps, classNames, EMPTY_VALUE, formatNumber } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

import { legoError, LegoTextInput } from '../../../../_lego';

export const NumberInput: React.FC<BaseInputProps<number | null>> = React.memo(
   ({ className, disabled, hasError, id, name, placeholder, readonly, readonlyClassName, value, onChange, onBlur }) => {
      const handleValueChange = useCallback(
         (v: string) => {
            const parsed = parseFloat(v);
            onChange(Number.isNaN(parsed) ? null : parsed);
         },
         [onChange],
      );

      if (readonly) {
         return <span className={readonlyClassName}>{value === null ? EMPTY_VALUE : formatNumber(value)}</span>;
      }

      return (
         <LegoTextInput
            cls={classNames(className, { [legoError]: hasError })}
            type={'number'}
            disabled={disabled}
            id={id}
            name={name}
            placeholder={placeholder}
            text={`${value ?? ''}`}
            onChange={handleValueChange}
            onBlur={onBlur}
         />
      );
   },
);

NumberInput.displayName = 'NumberInput';
