import { boolean, text } from '@storybook/addon-knobs';
import { Meta, Story } from '@storybook/react';
import React, { useCallback, useEffect, useState } from 'react';

import { SingleSelect, valuesToSelectItems } from './SingleSelect';

const Template: Story<{ initialValue: string; items: string[] }> = ({ initialValue = '', items }) => {
   const [value, setValue] = useState(initialValue);

   useEffect(() => {
      setValue(initialValue);
   }, [initialValue]);

   const handleChange = useCallback((v: string) => setValue(v), []);

   return (
      <SingleSelect
         items={valuesToSelectItems(items)}
         name={'test'}
         onChange={handleChange}
         value={value}
         placeholder={text('placeholder', '')}
         readonly={boolean('readonly', false)}
         disabled={boolean('disabled', false)}
         hasError={boolean('hasError', false)}
      />
   );
};

function generateItems(count: number) {
   return Array(count)
      .fill(null)
      .map((_, i) => `item${i}`);
}

const shortList = generateItems(2);
const longList = generateItems(25);

export const Empty = Template.bind({});
Empty.args = { initialValue: '', items: shortList };

export const HasValue = Template.bind({});
HasValue.args = { initialValue: 'item1', items: shortList };

export const ShowSearchForLongList = Template.bind({});
ShowSearchForLongList.args = { initialValue: 'item1', items: longList };

export default {
   title: 'components/forms/inputs/SingleSelect',
} as Meta;
