import { YCSelect, YCSelectItem, YCSelectItemsGroup } from '@yandex-data-ui/common';
import { BaseInputProps, classNames, EMPTY_VALUE } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './SingleSelect.module.css';

interface Props extends BaseInputProps<string | undefined> {
   className?: string;
   dataTest?: string;
   items: YCSelectItem[] | YCSelectItemsGroup[];
   showSearch?: boolean;
}

/**
 * Фасад над YCSelect, упрощающий его использования для статического плоского списка значений
 *
 * По умолчанию поиск отключен
 */
export const SingleSelect: React.FC<Props> = React.memo(
   ({ className, items, onChange, value, placeholder, disabled, readonly, readonlyClassName, showSearch, dataTest }) =>
      readonly ? (
         <div className={classNames(classes.readonly, `test-${dataTest}`, readonlyClassName)}>
            {value ?? EMPTY_VALUE}
         </div>
      ) : (
         <YCSelect
            className={classNames(className, `test-${dataTest}`)}
            disabled={disabled}
            items={items}
            onUpdate={onChange}
            placeholder={placeholder}
            showSearch={showSearch ?? items.length > 10}
            type={YCSelect.SINGLE}
            value={value}
         />
      ),
);

SingleSelect.displayName = 'SingleSelect';

export function valuesToSelectItems(values: string[]): YCSelectItem[] {
   return values.map(
      v =>
         ({
            key: v,
            value: v,
            title: v,
         } as YCSelectItem),
   );
}
