import { Meta } from '@storybook/react';
import { json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useCallback, useState } from 'react';
import { of } from 'rxjs';

import { TagInputEnhanced } from './TagInput';

export const SimpleTagInputStory = () => {
   const [value, setValue] = useState(new Set(['tag1', 'tag2']));
   const handleValueChange = useCallback((e: SyntheticEvent, v: Set<string>) => {
      setValue(v);
   }, []);

   return (
      <>
         <TagInputEnhanced value={value} onChange={handleValueChange} />

         <pre>{json(value)}</pre>
      </>
   );
};

export const SuggestionsTagInputStory = () => {
   const [value, setValue] = useState(new Set(['tag1', 'tag2']));
   const handleValueChange = useCallback((e: SyntheticEvent, v: Set<string>) => {
      setValue(v);
   }, []);

   const getSuggestions = useCallback((term: string) => of([term, `${term}111`, `${term}222`]), []);

   return (
      <>
         <TagInputEnhanced value={value} onChange={handleValueChange} getSuggestions={getSuggestions} />

         <pre>{json(value)}</pre>
      </>
   );
};

export default {
   title: 'components/forms/inputs/TagInput',
} as Meta;
