import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import { IListOption } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { TagList } from './TagList';

const items: IListOption[] = [
   { value: 'id1', name: 'market' },
   { value: 'id2', name: 'RTC' },
   { value: 'id3', name: 'RTC network' },
   { value: 'id4', name: 'runtime' },
];

export const Readonly = () => <TagList editable={false} items={items} />;

export const Editable = () => <TagList editable={true} items={items} onRemove={action('onRemove')} />;

export const Wrapped = () => (
   <div style={{ width: '20rem' }}>
      <TagList
         editable={false}
         items={[
            'item 1',
            'item 2',
            'item 3',
            'item 4',
            'item 5',
            'item 6',
            'item 7',
            'item 8',
            'very very very very very very very very log item',
         ].map(i => ({ name: i, value: i }))}
      />
   </div>
);

export default {
   // decorators: [fullWidthOutlineDecorator],
   title: 'components/forms/inputs/TagList',
} as Meta;
