import { classNames, IListOption } from '@yandex-infracloud-ui/libs';
import { Button, Icon } from 'lego-on-react';
import * as React from 'react';

import classes from './TagList.module.css';

export function setToListOptions(v: Set<string>): IListOption[] {
   return Array.from(v).map(i => ({ value: i, name: i } as IListOption));
}

interface Props {
   className?: string;
   editable: boolean;
   items: IListOption[];

   onRemove?(id: string): void;
}

export const TagList = React.memo(({ className = '', editable, items, onRemove }: Props) => {
   if (editable && !onRemove) {
      throw new Error('Expected onRemove prop if TagList is editable');
   }

   return (
      <div className={classNames(classes.tagList, className)} data-test={'TagList'}>
         {items.map(item => (
            <div
               key={item.value}
               className={classNames(classes.tag, { [classes.editable]: editable })}
               title={`${item.name}${item.note ? `: ${item.note}` : ''}`}
               data-test={'TagList:Tag'}
            >
               {item.name}

               {editable ? (
                  <Button
                     theme={'clear'}
                     size={'xs'}
                     icon={<Icon type={'close'} size={'xs'} />}
                     cls={classes.removeButton}
                     onClick={() => onRemove!(item.value)}
                  />
               ) : null}
            </div>
         ))}
      </div>
   );
});

TagList.displayName = 'TagList';
