import { Meta } from '@storybook/react';
import { DevJson } from '@yandex-infracloud-ui/libs';
import React, { useState } from 'react';

import { VCpuInput } from './VCpuInput';

const Story = ({ v }: { v: number | null }) => {
   const [value, setValue] = useState<number | null>(v);

   return (
      <>
         <VCpuInput name={'test'} value={value} onChange={setValue} />
         <DevJson open={true}>{value}</DevJson>
      </>
   );
};

export const Empty = () => <Story v={null} />;

export const Use_500MilliCores = () => <Story v={500} />;

export const Use_1Core = () => <Story v={1000} />;

export const Use_12Cores = () => <Story v={12000} />;

export const HugeButNotRounding = () => <Story v={12500} />;

export default {
   title: 'components/forms/inputs/VCpuInput',
} as Meta;
