import { BaseInputProps, formatNumber, RoundedInput, RoundMeasure } from '@yandex-infracloud-ui/libs';
import React from 'react';
import classes from './VCpuInput.module.css';

const measures: RoundMeasure[] = [
   { name: 'VCPU', multiplier: 1 },
   { name: 'CPU', multiplier: 1000 },
];

export const renderDetails = (v: number) => `${formatNumber(v)} VCPU, ${formatNumber(v / 1000, '0.[0]')} CPU`;

interface Props extends BaseInputProps<number | null> {
   useRenderDetails?: boolean;
}

export const VCpuInput: React.FC<Props> = React.memo(({ useRenderDetails = true, ...props }) => (
   <RoundedInput
      defaultMeasure={'CPU'}
      measures={measures}
      useRenderDetails={useRenderDetails}
      renderDetails={renderDetails}
      fixedWidth={75}
      readonlyClassName={classes.readonly}
      {...props}
   />
));

VCpuInput.displayName = 'VCpuInput';
