import { classNames } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';

import classes from './FormFieldSet.module.css';

interface Props {
   bodyClassName?: string;
   className?: string;
   title: ReactNode;
}

export const FormFieldSet: React.FC<Props> = React.memo(({ className, bodyClassName, title, children }) => (
   <div className={classNames(classes.wrapper, className)}>
      <div className={classes.title}>{title}</div>
      <div className={classNames(classes.body, bodyClassName)}>{children}</div>
   </div>
));

FormFieldSet.displayName = 'FormFieldSet';
