import { DeepPartial } from '../../../../models';
import type { RootState } from '../../../../redux';
import { selectCurrentFormState, selectFormsHasUnsavedChanges, selectFormStates } from './formStatesSlice';

describe('components/forms|FormLocalState/formStateSlice', () => {
   describe('selectors', () => {
      const s: RootState = ({
         formStates: {
            '/stages/yyy': { id: '/stages/xxx', lastChange: null, state: { values: { id: 'xxx' } } },
            '/stages/xxx': { id: '/stages/xxx', lastChange: null, state: { values: { id: 'xxx' } } },
            '/stages/xxx/du-zzz': { id: '/stages/xxx/du-zzz', lastChange: null, state: { values: { id: 'zzz' } } },
         },
      } as DeepPartial<RootState>) as any;

      it('selectFormStates', () => {
         expect(selectFormStates(s)).toEqual(
            new Map([
               ['/stages/yyy', { id: '/stages/xxx', lastChange: null, state: { values: { id: 'xxx' } } }],
               ['/stages/xxx', { id: '/stages/xxx', lastChange: null, state: { values: { id: 'xxx' } } }],
               ['/stages/xxx/du-zzz', { id: '/stages/xxx/du-zzz', lastChange: null, state: { values: { id: 'zzz' } } }],
            ]),
         );
      });

      it('selectFormsHasUnsavedChanges', () => {
         expect(selectFormsHasUnsavedChanges(s, '/stages/zzz')).toBe(false);

         expect(selectFormsHasUnsavedChanges(s, '/stages/xxx')).toBe(true);
      });

      it('selectCurrentFormState', () => {
         expect(selectCurrentFormState(s, '/stages/xxx/du-zzz')).toEqual({ values: { id: 'zzz' } });

         expect(selectCurrentFormState(s, '/stages/zzz')).toBeUndefined();
      });
   });
});
