import { faUndo } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { formatDate, styleHelpers } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { LegoButton } from '../../../../_lego';

import classes from './FormRevertButton.module.css';

interface Props {
   buttonTitle: string;
   className?: string;
   lastChange: Date | null;
   readonly?: boolean;

   onClick(): void;
}

export const FormRevertButton: React.FC<Props> = React.memo(
   ({ className, buttonTitle, lastChange, onClick, readonly }) => {
      if (lastChange === null) {
         return null;
      }

      return (
         <div className={className} data-e2e={'FormRevertButton'}>
            <span className={classes.text} data-e2e={'FormRevertButton:LastChanged'}>
               Last changed: {formatDate(lastChange)}
            </span>
            {readonly ? null : (
               <LegoButton
                  theme={'clear'}
                  tone={'grey'}
                  size={'xs'}
                  onClick={onClick}
                  title={buttonTitle}
                  cls={styleHelpers.leftSpace}
                  controlAttrs={{ 'data-e2e': 'FormRevertButton:RevertButton' }}
               >
                  <FontAwesomeIcon icon={faUndo} color={'var(--yc-color-text-primary)'} />
               </LegoButton>
            )}
         </div>
      );
   },
);

FormRevertButton.displayName = 'FormRevertButton';
