import { classNames } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';
import classes from './FormSection.module.css';

interface Props {
   className?: string;
   readonly?: boolean;
   title?: ReactNode;
}

export const FormSection: React.FC<Props> = ({ className, title, children, readonly = false }) => (
   <div className={classNames(className, { [classes.body]: !readonly })}>
      {title ? <div className={classes.title}>{title}</div> : null}
      {children}
   </div>
);

FormSection.displayName = 'FormSection';
