import { faFileCode as faFileCodeFill } from '@fortawesome/free-solid-svg-icons';
import { faFileCode as faFileCodeEmpty } from '@fortawesome/pro-regular-svg-icons';
import { boolean, number, select } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { TabsDirection } from '@yandex-cloud/uikit';
import React, { useEffect, useState } from 'react';

import { FormTab } from './FormTab';
import { FormTabs } from './FormTabs';

export const Regular = () => {
   const [tab, setTab] = useState('tab1');

   useEffect(() => {
      setTimeout(() => {
         setTab('tab2');
      }, 2000);
   }, []);

   return (
      <FormTabs
         activeTab={tab}
         onSelectTab={setTab}
         direction={select('direction', [TabsDirection.Horizontal, TabsDirection.Vertical], TabsDirection.Horizontal)}
      >
         <FormTab
            id={'tab1'}
            title={'Init command'}
            isEmpty={boolean('isEmpty', false)}
            emptyIcon={faFileCodeEmpty}
            fillIcon={faFileCodeFill}
            count={number('count', 3)}
         >
            Tab #1 content
         </FormTab>

         <FormTab
            id={'tab2'}
            title={'Start command'}
            isRequired={true}
            isEmpty={boolean('isEmpty', false)}
            emptyIcon={faFileCodeEmpty}
            fillIcon={faFileCodeFill}
         >
            Tab #2 content
         </FormTab>

         <FormTab
            id={'tab3'}
            title={'Liveness probe'}
            disabled={true}
            isEmpty={boolean('isEmpty', false)}
            emptyIcon={faFileCodeEmpty}
            fillIcon={faFileCodeFill}
         >
            Tab #3 content
         </FormTab>
      </FormTabs>
   );
};

export default {
   title: 'components/forms/parts/FormTabs',
} as Meta;
