import { Tabs, TabsDirection } from '@yandex-cloud/uikit';
import { classNames } from '@yandex-infracloud-ui/libs';
import React, { ReactElement, ReactNode, useCallback, useEffect, useState } from 'react';

import { FormTabProps } from './FormTab';
import classes from './FormTabs.module.css';

export interface FormTabsProps {
   /**
    * Дополнительный элемент рядом с вкладками.
    */
   actions?: ReactNode;
   activeTab?: string;

   /**
    * Расположение вкладок
    *
    * По-умолчанию горизонтальное
    */
   direction?: TabsDirection;

   onSelectTab?(tab: string): void;
}

/**
 * @deprecated Используйте SmartTabs из либы (там то же самое)
 */
export const FormTabs: React.FC<FormTabsProps> = React.memo(
   ({ actions, activeTab, onSelectTab, children, direction = TabsDirection.Horizontal }) => {
      const tabs = (React.Children.toArray(children) as ReactElement<FormTabProps>[])
         // eslint-disable-next-line no-underscore-dangle
         .filter(node => node.props.__ROLE === 'FormTab')
         .map(section => {
            const { props } = section;

            return {
               content: props.children,
               disabled: props.disabled,
               hint: props.title,
               id: props.id,
               isEmpty: props.isEmpty,
               title: section,
            };
         });

      // Либо явно переданный, либо первый не пустой, либо просто первый
      const [currentTab, setCurrentTab] = useState(activeTab ?? tabs?.find(t => !t.isEmpty)?.id ?? tabs?.[0]?.id ?? '');

      useEffect(() => {
         if (activeTab) {
            setCurrentTab(activeTab);
         }
      }, [activeTab]);

      const handleSelectTab = useCallback(
         (tab: string) => {
            setCurrentTab(tab);

            if (onSelectTab) {
               onSelectTab(tab);
            }
         },
         [onSelectTab],
      );

      return (
         <div
            className={classNames({
               [classes.wrapperHorizontal]: direction === TabsDirection.Horizontal,
               [classes.wrapperVertical]: direction === TabsDirection.Vertical,
            })}
         >
            <div className={classes.tabs} data-e2e={'FormTabs'}>
               <Tabs items={tabs} activeTab={currentTab} direction={direction} onSelectTab={handleSelectTab} />
               {actions}
            </div>

            {direction === TabsDirection.Vertical && <div className={classes.divider} />}

            {tabs
               .filter(tab => tab.id === currentTab)
               .map(tab => (
                  <div key={tab.id} className={classes.content} data-e2e={`FormTabContent:${tab.id}`}>
                     {tab.content}
                  </div>
               ))}
         </div>
      );
   },
);

FormTabs.displayName = 'FormTabs';
