import { Meta, Story } from '@storybook/react';
import React from 'react';
import { useLocation } from 'react-router';

import { routerDecorator } from '../../../../stories';

import { FormTab } from '../FormTabs/FormTab';
import { FormTabsWithUrl } from './FormTabsWithUrl';

const Template: Story<{}> = () => {
   const location = useLocation();

   return (
      <>
         <h1>Location hash: "{location.hash}"</h1>

         <FormTabsWithUrl defaultTab={'form'}>
            <FormTab id={'form'} title={'Form'}>
               FORM
            </FormTab>
            <FormTab id={'secrets'} title={'Secrets'}>
               SECRETS
            </FormTab>
         </FormTabsWithUrl>
      </>
   );
};

export const Regular = Template.bind({});

Regular.storyName = 'FormTabsWithUrl'; // Remove if it isn't single story
Regular.args = {};

export default {
   decorators: [routerDecorator],
   title: 'components/forms/parts/FormTabsWithUrl',
} as Meta;
