import React, { useCallback } from 'react';
import { useHistory, useLocation } from 'react-router';

import { FormTabs, FormTabsProps } from '../FormTabs/FormTabs';

interface Props extends Omit<FormTabsProps, 'activeTab' | 'onSelectTab'> {
   defaultTab: string;
}

export const FormTabsWithUrl: React.FC<Props> = React.memo(({ defaultTab, ...props }) => {
   const history = useHistory();
   const location = useLocation();

   const handleSelectTab = useCallback(
      (tab: string) => {
         history.replace({ hash: tab === defaultTab ? '' : tab });
      },
      [defaultTab, history],
   );

   return (
      <FormTabs
         {...props}
         activeTab={location.hash ? location.hash.substring(1) : defaultTab}
         onSelectTab={handleSelectTab}
      />
   );
});

FormTabsWithUrl.displayName = 'FormTabsWithUrl';
