import { useCallback } from 'react';
import { useStore } from 'react-redux';
import { Store } from 'redux';

import type { RootState } from '../../../redux';
import { delListItem } from '../../../utils';
import { AnyFormLevelConfig, AnySubForm } from '../models';

/**
 * Сложный код из-за сложной задачи. Нужно из "плоской" иерархии собрать реальную иерархичную модель.
 */
export function valueFromForms(forms: AnySubForm[], levelConfigs: AnyFormLevelConfig[], reduxStore: Store) {
   const { formStates } = reduxStore.getState() as RootState;

   function getCurrentFormValues({ id, formParams }: AnySubForm) {
      const currentValues = formStates[id]?.state.values;

      return currentValues
         ? {
              ...currentValues,
              initialId: formParams.initialId,
           }
         : formParams;
   }

   let rootValue = null;
   // noinspection JSMismatchedCollectionQueryUpdate
   let previousForms: AnySubForm[];
   const valuesMap = new Map<string, any>();
   let first = true;

   /* eslint-disable no-continue */
   for (const { id, formParamsToValue } of levelConfigs) {
      if (first) {
         const form = forms[0]!;
         rootValue = formParamsToValue(getCurrentFormValues(form), form.value);
         valuesMap.set(form.id, rootValue);
         previousForms = [form];
         first = false;

         continue;
      }

      const levelForms = forms.filter(f => f.levelConfig.id === id);
      const currentForms: AnySubForm[] = [];
      for (const previousForm of previousForms!) {
         for (const levelForm of levelForms) {
            if (levelForm.parentForms[0].id !== previousForm.id) {
               continue;
            }
            const children = previousForm.levelConfig.getChildren(valuesMap.get(previousForm.id));
            const v = formParamsToValue(getCurrentFormValues(levelForm), levelForm.value);

            if (levelForm.isRemoved) {
               delListItem(children, c => c.id === v.id);
            } else {
               valuesMap.set(levelForm.id, v);
               children.push(v);
               currentForms.push(levelForm);
            }
         }
      }
      previousForms = currentForms;
   }
   /* eslint-enable no-continue */

   return rootValue;
}

export function useValueFromForms(forms: AnySubForm[], levelConfigs: AnyFormLevelConfig[]) {
   const reduxStore = useStore();

   return useCallback(() => valueFromForms(forms, levelConfigs, reduxStore), [forms, levelConfigs, reduxStore]);
}
